set V := {1,2,3,4,5,6};
set X := {1,2,3};

set E := { <1,4>, <1,5>, <1,6>, <2,3>, <2,4>, <2,5>, <3,5>, <3,6>, <4,5>, <5,6> };

param w[E] := 
      <1,4> 2, 
      <1,5> 5, 
      <1,6> 5, 
      <2,3> 9, 
      <2,4> 3, 
      <2,5> 4, 
      <3,5> 6, 
      <3,6> 5, 
      <4,5> 4, 
      <5,6> 4;

var x[E] real >= 0 <= 1;

minimize obj: sum <i,j> in E : x[i,j]*w[i,j];

set P[] := powerset(V);
set I   := indexset(P);

subto cut:
      forall <i> in I with P[i]  inter X != {} 
                  and (V \ P[i]) inter X != {} do
        sum <u,v> in E with (<u> in P[i] and not <v> in P[i])
                         or (<v> in P[i] and not <u> in P[i]) : x[u,v] >= 1;

