set V := {1,2,3,4,5};
set E := { <1,2>, <1,3>, <1,4>, <1,5>, <2,3>, <2,4>, <2,5>, <3,4>, <3,5>, <4,5>};

param w[E] := <1,2> 3,
              <1,3> 4,
              <1,4> 5,
              <1,5> 1,
              <2,3> 10,
              <2,4> 6,
              <2,5> 4,
              <3,4> 9,
              <3,5> 4,
              <4,5> 1;

set P[] := powerset(V);
set K   := indexset(P);

var x[E] integer >= 0 <= 1;

minimize obj: sum <i,j> in E : x[i,j]*w[i,j];

subto assignment:
      forall <i> in V do
      	     sum <u,v> in E with u==i or v==i : x[u,v] == 2;
     
subto subtour:
      forall <k> in K with card(P[k]) > 0 and card(P[k]) < card(V) do
             sum <u,v> in E with ((<u> in P[k]) and (<v> in P[k])) :
                   x[u,v] <= card(P[k])-1;

