<?php
// Turing-maskine simulator
// Version 0.1.1 beta, 11/11-2006
// - Semantiske rettelser 
// 
// Version 0.1 beta, 27/10-2006
// - Frste version
// 
// Lavet af Morten Skyt, m@mortenskyt.com
// 
// Kildekoden er ikke licenseret - brug den som du lyster.

if(!(($srcOrig=$_POST['src']) && ($tapeOrig=$_POST['tape']))) {
	die("Mangler data");
}


// lg kilden i et multidimensionelt array
$srcLines = explode("\n",$srcOrig);
foreach($srcLines as $srcLine) {
	list($func,$cond,$act,$dir,$goto) = explode(" ",$srcLine);
	$src[] = array("func" => strtolower(trim($func)),
	               "cond" => strtolower(trim($cond)),
	               "act" => strtolower(trim($act)),
	               "dir" => strtolower(trim($dir)),
	               "goto" => strtolower(trim($goto)));
}

// lg bndet i et multidimensionelt array
$tape = explode(" ",trim($tapeOrig));

// ryd op
unset($func,$cond,$act,$dir,$goto);




// startdata
$func = "start";
$head = $_POST['headstart']=="r"?count($tape)-1:0; // st lse/skrive-hoved til slutningen af bndet


// okay, kr programmet!
for($i=0; $func != "halt" && $i<5000; $i++) {
	// er der data i denne celle?
	if (!isset($tape[$head]))
	  $tape[$head] = "*"; // s m cellen indeholde en stjerne
	
	// hvilken data er i denne celle?
	$curCell = $tape[$head];
	
	// lb gennem kommandoer og lav array over kommandoer der kan bruges her
	unset($curFuncs, $curFunc);
	foreach($src as $line) {
	  if ($line["func"] == $func)
	    $curFuncs[] = $line;
	}
	
	echo "Hovedposition: ".$head.", vaerdi: ".$tape[$head].", kommando: $func\n";
	echo "Hoved: ";
	foreach($tape as $tapecell) {
		echo $tapecell . " ";	
	}
	echo "\n\n";
	
	// find korrekt kommando
	foreach($curFuncs as $curFuncTmp) {
		if ($curFuncTmp["cond"] == $tape[$head]) {
		  $curFunc = $curFuncTmp;
		  break;
		}
	}
	
	// kr kommando
	if (!$curFunc)
	  die("Advarsel: Der var ingen traek for dette input.\n\n");
	
	// skriv p bndet
	$tape[$head] = ($curFunc["act"]);
	
	// flyt hovedet
	if ($curFunc["dir"] == "r")
	  $head++;
	elseif ($curFunc["dir"] == "l")
	  $head--;
	elseif ($curFunc["dir"] != "-")
	  die("Kritisk fejl: Ugyldig retning baandhovedet skal gaa i.\n\n");
	
	// st funktion til nste funktion
	$func = $curFunc["goto"];
	
}

// endelig hovedposition
echo "Hovedposition: ".$head.", vaerdi: ".$tape[$head].", kommando: $func\n";
echo "Hoved: ";
foreach($tape as $tapecell) {
	echo $tapecell . " ";	
}
echo "\n\n";

?>
