# Example Python3 Code for the lecture on Graph Theory in DM534 by Daniel Merkle Nov. 28, 2017.

from math import *
from copy import *

# Assume M and N are both square (size x size) matrices 

def multSquareMatrices(M,N):
    size = len(M)
    result = [[0 for x in range(size)] for y in range(size)]

    for i in range(size):
        for j in range(size):
            for k in range(size):
                result[i][j] = result[i][j] + M[i][k] * N[k][j]
                
    return result

def addSquareMatrices(M,N):
    size = len(M)
    result = [[0 for x in range(size)] for y in range(size)]

    for i in range(size):
        for j in range(size):
            result[i][j] = M[i][k] + N[k][j]
                
    return result


def printMatrix(M):
    for row in M:
        print(["%3.0f" % a for a in row])
    print("\n")


A = [[0,1,0,0,1,0],
     [1,0,1,0,1,0],
     [0,1,0,0,0,0],
     [0,0,0,0,1,1],
     [1,1,0,1,0,0],
     [0,0,0,1,0,0]]

# make a copy of X
R = deepcopy(A)

print("Initial Matrix:\n")
printMatrix(A)
    
for i in range(2,5):
    print("%d-th power of A : \n"%i)
    R = multSquareMatrices(R,A)
    printMatrix(R)
