# Example Python3 Code for the lecture on Graph Theory in DM534 by Daniel Merkle Nov. 28, 2017.

from math import *
from copy import *

# Assume M and N are both square (size x size) matrices 

def multModSquareMatrices(M,N):
    size = len(M)
    result = [[inf for x in range(size)] for y in range(size)]

    for i in range(size):
        for j in range(size):
            for k in range(size):
                result[i][j] = min(result[i][j], M[i][k] + N[k][j])
                
    return result

def addSquareMatrices(M,N):
    size = len(M)
    result = [[0 for x in range(size)] for y in range(size)]

    for i in range(size):
        for j in range(size):
            result[i][j] = M[i][k] + N[k][j]
                
    return result


def printMatrix(M):
    for row in M:
        print(["%3.0f" % a for a in row])
    print("\n")


W = [[   0,   1, inf, inf,   2, inf], 
     [   1,   0,   2, inf,   4, inf], 
     [ inf,   2,   0, inf, inf,   3], 
     [ inf, inf, inf,   0,   6,   1], 
     [   2,   4, inf,   6,   0, inf], 
     [ inf, inf,   3,   1, inf,   0]]

# make a copy of X
R = deepcopy(W)

print("Initial Matrix:\n")
printMatrix(W)

# Compute the distance matrix iteratively
# by computation of W^2, W^3, ..., W^5
# (In general one needs to compute W^(n-1))
for i in range(2,6):
    print("%d-th power of W : \n"%i)
    R = multModSquareMatrices(R,W)
    printMatrix(R)
