# Prints a SAT program in CNF for the 3x3 towers problem.
#
# Here in a second version which first collects the clauses and then
# formats the output in the end (which is arguably cleaner, as it
# separates the construction and the formatting phases). Each clause
# is a list of ints.
#
# It also switches to list comprehension instead of for-loops, just
# for variation.

def pair2int(row,col):
    return 3*(row-1)+col

def attackRestOfRowLeft(row,col): # returns a list of clauses
    lengthOfRest = 3-col
    return [[-pair2int(row,col), -pair2int(row,col+k)] for k in range(1,lengthOfRest+1)]

def attackRestOfColumnDown(row,col): # returns a list of clauses
    lengthOfRest = 3-row
    return [[-pair2int(row,col), -pair2int(row+k,col)] for k in range(1,lengthOfRest+1)]

def rowNotEmpty(row): # returns a single clause
    return [pair2int(row,col) for col in range(1,4)]

clauses = []
for row in range(1,4):
    for col in range(1,4):
        clauses.extend(attackRestOfRowLeft(row,col))
        clauses.extend(attackRestOfColumnDown(row,col))
for row in range(1,4):
    clauses.append(rowNotEmpty(row))

print("p cnf", 9, len(clauses))        
for clause in clauses:
    clause.append(0)
    print(*clause) # The use of * during a call unpacks a list, i.e.,
                   # its elements become arguments of the call to
                   # print (exploiting that print can work with any
                   # number of arguments).
